clear all
set more off

******************************************************
u 2024-00551+使用数据\house_data,clear 

****************************************************************
* 图1 A B C
****************************************************************
rdplot lnprice dist_bd ,c(0) p(1) nbins(10) ///
graph_options( ///
title("(A)",color(black) size(*1) position(6)) ///
xtitle("",size(*1) )  ///
ytitle("ln 房价",size(*1)) ///
ylabel(1.85 2 2.15,labsize(*1) angle(90) grid) ///
xlabel(,labsize(*1) ) ///
graphregion(fcolor(white)) legend(off))
graph save 2024-00551+日志文件\fig_house1.gph,replace 

rdplot lnprice dist_bd ,c(0) p(2) nbins(10) ///
graph_options( ///
title("(B)",color(black) size(*1) position(6)) ///
xtitle("",size(*1) )  ///
ytitle("ln 房价",size(*1)) ///
ylabel(1.85 2 2.15,labsize(*1) angle(90) grid) ///
xlabel(,labsize(*1) ) ///
graphregion(fcolor(white)) legend(off))
graph save 2024-00551+日志文件\fig_house2.gph,replace 

rdplot lnprice dist_bd ,c(0) p(3) nbins(10)  ///
graph_options( ///
title("(C)",color(black) size(*1) position(6)) ///
xtitle("",size(*1) )  ///
ytitle("ln 房价",size(*1)) ///
ylabel(1.85 2 2.15,labsize(*1) angle(90) grid) ///
xlabel(,labsize(*1) ) ///
graphregion(fcolor(white)) legend(off))
graph save 2024-00551+日志文件\fig_house3.gph,replace 

****************************************************************
* 表2A
****************************************************************
global x " area level str type direction years inner str_1 heat year_d1 elevator year_d2 right "

reghdfe lnprice treat dist_bd inter  $x  if distance<=.5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m1

reghdfe lnprice treat dist_bd inter   $x if distance<=1,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m2

reghdfe lnprice treat dist_bd inter  $x  if distance<=2,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m3

reghdfe lnprice treat dist_bd inter  $x  if distance<=3,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m4

reghdfe lnprice treat dist_bd inter  $x  if distance<=4,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m5

reghdfe lnprice treat dist_bd inter  $x  if distance<=5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m6

local s  "using 2024-00551+日志文件\table2A.rtf"   
local m  " m1 m2 m3 m4 m5 m6 "  
local mt " <=.5km <=1km <=2km <=3km <=4km <=5km"  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial controls Year N) sfmt(fmt %12.0f) ///
title( "Table 2A" )

**************************************************************
* 稳健性检验：2次项拟合
* 附录 表A1(A)
****************************************************************
reghdfe lnprice treat dist_bd inter dist_bd2 dist_bd2d $x  if distance<=.5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m1

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d $x if distance<=1,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m2

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d $x  if distance<=2,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m3

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d $x  if distance<=3,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m4

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d $x  if distance<=4,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m5

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d $x  if distance<=5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m6

local s  "using 2024-00551+日志文件\tableA1_A.rtf"   
local m  " m1 m2 m3 m4 m5 m6 "  
local mt " <=.5km <=1km <=2km <=3km <=4km <=5km"  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial controls Year N) sfmt(fmt %12.0f) ///
title( "Table A1---A" )

**************************************************************
* 稳健性检验 3次项拟合
* 附录 表A1(B)
****************************************************************
reghdfe lnprice treat dist_bd inter dist_bd2 dist_bd2d dist_bd3 dist_bd3d $x  if distance<=.5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m1

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d dist_bd3 dist_bd3d $x if distance<=1,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m2

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d dist_bd3 dist_bd3d $x  if distance<=2,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m3

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d dist_bd3 dist_bd3d $x  if distance<=3,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m4

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d dist_bd3 dist_bd3d $x  if distance<=4,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m5

reghdfe lnprice treat dist_bd inter  dist_bd2 dist_bd2d dist_bd3 dist_bd3d $x  if distance<=5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
est store m6

local s  "using 2024-00551+日志文件\tableA1_B.rtf"   
local m  " m1 m2 m3 m4 m5 m6 "  
local mt " <=.5km <=1km <=2km <=3km <=4km <=5km"  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial controls Year N) sfmt(fmt %12.0f) ///
title( "Table A1---B" )

****************************************************************
* 稳健性检验：控制商圈固定效应
* 正文表1第13列的回归结果
* 附录 表A2 
****************************************************************

reghdfe lnprice treat dist_bd inter  $x  if distance<=.35,absorb(所在商圈 year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local Block "Y"
est store m1

reghdfe lnprice treat dist_bd inter  $x  if distance<=.4,absorb(所在商圈 year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local Block "Y"
est store m2

reghdfe lnprice treat dist_bd inter  $x  if distance<=.45,absorb(所在商圈 year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local Block "Y"
est store m3

* 正文表1第13列的回归结果
reghdfe lnprice treat dist_bd inter   $x if distance<=.5,absorb(所在商圈 year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local Block "Y"
est store m4  

reghdfe lnprice treat dist_bd inter   $x if distance<=.55,absorb(所在商圈 year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local Block "Y"
est store m5

local s  "using 2024-00551+日志文件\tableA2.rtf"   
local m  " m1 m2 m3 m4 m5 "  
local mt " <=350m <=400m  <=450m <=500m <=550m"  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial controls Year Block N) sfmt(fmt %12.0f) ///
title( "Table A2 " )

****************************************************************
* 稳健性检验：控制与 天安门的距离
* 正文表1第16列的回归结果
* 附录 表A3
****************************************************************
reghdfe lnprice treat dist_bd inter sq_distance $x  if distance<=.5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local distance2sq "Y"
est store m1

reghdfe lnprice treat dist_bd inter sq_distance  $x if distance<=1,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local distance2sq "Y"
est store m2

reghdfe lnprice treat dist_bd inter sq_distance $x  if distance<=2,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local distance2sq "Y"
est store m3

reghdfe lnprice treat dist_bd inter sq_distance $x  if distance<=3,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local distance2sq "Y"
est store m4

* 正文表1第16列的回归结果
reghdfe lnprice treat dist_bd inter sq_distance $x  if distance<=4,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local distance2sq "Y"
est store m5

reghdfe lnprice treat dist_bd inter sq_distance $x  if distance<=5,absorb( year) vce(cluster community)
estadd local Polynomial   "Y"  
estadd local controls "Y"
estadd local Year "Y"
estadd local distance2sq "Y"
est store m6

local s  "using 2024-00551+日志文件\tableA3.rtf"   
local m  " m1 m2 m3 m4 m5 m6 "  
local mt " <=.5km <=1km <=2km <=3km <=4km <=5km"  
esttab `m'`s', ///
replace mtitle(`mt') b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
keep(treat ) se  ///
scalar(Polynomial controls Year distance2sq N) sfmt(fmt %12.0f) ///
title( "Table A3" )

****************************************************************
* 表1第17列的回归结果  
* rdrobust
****************************************************************
tab year,gen(year_)
rdrobust lnprice dist_bd  ,c(0) p(1) covs($x year_2- year_12) kernel(tri) bwselect(mserd)
estadd local Polynomial   "Y"  
estadd local control "Y"
est store m1

esttab m1 using "2024-00551+日志文件\table2C---17column.rtf", ///
replace mtitle(rdrobust) b(%6.3f) nogap compress label ///
star(* 0.1 ** 0.05 *** 0.01)  ///
se scalar(Polynomial control N) sfmt(fmt %12.0f) ///
title( "Table 1C---17column" )
